#####################################   UFCALAUTO.PY   ##################################################
#                                                                                                       
# ufcalauto.py is a python program to calibrate UF spectra                     
#                                                                                                       
# The script needs:                                                                                     
#        * copy ufcalauto.py to TOPSPIN/exp/stan/nmr/py/user/                                              
#
# execution by topspin command:  ufcalauto
#
# Compatible with Bruker Topspin 2.x; Topspin 3.x
# Not compatible with Topspin 1.x 

#
# Version: 2017-02-20
#
# Author: Laetitia ROUGER, Laboratoire CEISAM, Nantes
# Mail: Laetitia.Rouger@univ-nantes.fr
# Supervisor: Patrick GIRAUDEAU,  Laboratoire CEISAM, Nantes
# Mail: Patrick.Giraudeau@univ-nantes.fr
########################################################################################################

from de.bruker.nmr.prsc.util import DataChecks
from de.bruker.nmr.jutil.xwin import UtilXwin
import os.path
import time
import shutil
import struct

#_____________________________________________________MESSAGES______________________________________________________
def msg_nodata():
        ERRMSG('No NMR data open or selected')
def msg_no2D(DIM):
        ERRMSG('Current data set is a '+str(DIM)+' dimension acquisition data','Incorrect dimension')
        
#__________________________________________________MAIN PROGRAM_______________________________________________

        
sys.stdout.write('___________________________UFCALAUTO START______________________________ \r\n')
#********************** Check if acquisition parameters are 2D NMR****************************************
DIM=GETACQUDIM()
if DIM==-1:
        msg_nodata()
        EXIT()
if DIM!=2:
        msg_no2D(DIM)
        EXIT()
dim=range(1,DIM+1)
#******************************************end*************************************************************
    
#********************** Determine spectrometer features ***************************************************
progpath = sys.argv[0]
stanindex = progpath.find('stan')
featuresfilepath = progpath[:(stanindex+9)]+'au/src/user/UFfeatures1H.txt'
featuresfile = open(featuresfilepath, 'r')
line = featuresfile.readline()
linesize=len(line)
e=float(line[:(linesize-1)])
line = featuresfile.readline()
linesize=len(line)
maxGradDisp=float(line[:(linesize-1)])
featuresfile.close()

#********************** Determine acquisition type *******************************************************
pulprog=(GETPAR('PULPROG'))
				
#********************** Calculate spectral width ***************************************************
Ta=float(GETPARSTAT('P 15'))
Ga=float(GETPARSTAT('GPZ 15'))
Te=float(GETPARSTAT('P 11'))
d6=float(GETPARSTAT('D 6'))

Te = Te / 1000000     # in s
Ta = Ta / 1000000     # in s

SW1 = 1/(2*(Ta+d6))		# in Hz
SW2 = (Ga * Ta * maxGradDisp)/(Te * 2 * e * 100)		# in Hz
#********************** Calculte OFFSET ***************************************************
SFO1=float(GETPAR('SFO1'))
O1p=float(GETPAR('O1P'))
OFFSET1 = O1p + SW1/(SFO1*2)
OFFSET2 = 0
if (pulprog=='iufcosy') or (pulprog=='iuftocsy'):
	OFFSET2 = O1p + SW2/(SFO1*2)
if pulprog=='iufdqs':
	OFFSET2 = 2*O1p + SW2/(SFO1*2)
#********************** Apply new processed spectral width and new left offset*****************************
XCMD('2s sw_p '+str(SW2))
XCMD('1s sw_p '+str(SW1))

XCMD('2s OFFSET '+str(OFFSET2))
XCMD('1s OFFSET '+str(OFFSET1))

#********************** Back to dataset ****************************************************************
XCMD('.f1r')#zoom all
XCMD('.f2r')
#MSG('Calibration done')
EXIT()
#__________________________________________________END________________________________________________________________
